(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     24932,        667]*)
(*NotebookOutlinePosition[     25632,        691]*)
(*  CellTagsIndexPosition[     25588,        687]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Integrales de l\[IAcute]nea. Campos conservativos", "Title"],

Cell[CellGroupData[{

Cell["Introducci\[OAcute]n", "Section"],

Cell["\<\
Aqu\[IAcute] te indico las soluciones de los ejercicios de la \
pr\[AAcute]ctica 3. Lo hago para introducir algunos comandos \[UAcute]tiles y \
para repasar los conceptos de campo vectorial localmente conservativo y campo \
vectorial conservativo que me parece que no ten\[EAcute]is nada claros.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell["\<\
Define comandos que calculen simb\[OAcute]licamente integrales de \
l\[IAcute]nea de campos escalares de dos y tres variables. La sintaxis de \
estos comandos debe ser de la forma \"integlinea[f_,\[Gamma]_,a_,b_]\" donde \
debes suponer que \"f\" es el nombre de una funci\[OAcute]n conocida de dos o \
tres variables, \"\[Gamma]\" es el nombre de la funci\[OAcute]n que nos da el \
camino de integraci\[OAcute]n y que se integra en el intervalo [a,b].\
\>", "ExerciseText"],

Cell[BoxData[
    \(integlinea[f_, \[Gamma]_, tmin_, tmax_] := 
      Integrate[
        Apply[f, \[Gamma][t]]*\@\(\(\[Gamma]'\)[t] . \(\[Gamma]'\)[t]\), {t, 
          tmin, tmax}]\)], "Input"],

Cell[TextData[{
  "El comando anterior calcula integrales de l\[IAcute]nea de campos \
escalares de cualquier n\[UAcute]mero de variables. Ya conoc\[EAcute]is las \
complicaciones que aparecen cuando se quiere aplicar una funci\[OAcute]n a un \
vector. La dificultad est\[AAcute] en que las funciones en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " conviene definirlas de la forma func[x,y] o func[x,y,z] y as\[IAcute] \
definidas no pueden trabajar directamente sobre vectores de la forma {x,y} o \
{x,y,z}. El comando Apply[f,expr] es \[UAcute]til para eso: reemplaza la \
cabeza de \"expr\" por f. Este comando tambi\[EAcute]n se escribe en la forma \
f@@expr."
}], "Text"],

Cell[BoxData[{
    \(Apply[f, {a, b}]\), "\[IndentingNewLine]", 
    \({Head[{a, b}], Head[f[a, b]]}\)}], "Input"],

Cell[BoxData[{
    \(\(f[x_, y_, z_] := {g[x, y, z], 
          h[x, y, z]};\)\), "\[IndentingNewLine]", 
    \(Apply[f, {a, b, c}]\), "\[IndentingNewLine]", 
    \(Clear[f, g, h]\)}], "Input"],

Cell[BoxData[{
    \(Apply[f, {{a, b}, {c, d}, {u, v, w}}]\), "\[IndentingNewLine]", 
    \(Apply[f, {{a, b}, {c, d}, {u, v, w}}, {1}] (*\ 
      se\ aplica\ el\ comando\ en\ el\ nivel\ 1\ de\ la\ lista, \ 
      es\ decir, \ 
      a\ los\ elementos\ de\ la\ lista\  - \ 
        Head[expresion]\ corresponde\ al\ nivel\ 0\ de\ "\<expresion\>"\ que\ \
es\ al\ que\ se\ aplica\ por\ defecto\ y\ no\ es\ preciso\ especificarlo\ *) \
\)}], "Input"],

Cell["Observa la diferencia con Map[f, expr].", "Text"],

Cell[BoxData[
    \(Map[f, {{a, b}, {c, d}, {u, v, w}, x, y, z}]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell["\<\
Repite lo hecho en el ejercicio 1 para definir un comando \
\"integlineavector[f_,\[Gamma]_,a_,b_]\" que calcule simb\[OAcute]licamente \
integrales de l\[IAcute]nea de campos vectoriales de dos y tres variables.\
\>", "ExerciseText"],

Cell[BoxData[
    \(integlineavector[F_, \[Gamma]_, a_, b_] := 
      Integrate[
        Apply[F, \[Gamma][t]] . \(\[Gamma]'\)[t], {t, a, b}]\)], "Input"],

Cell["\<\
El comando anterior calcula integrales de l\[IAcute]nea de campos vectoriales \
de cualquier n\[UAcute]mero de variables.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "a) Define un comando para aproximar la integral de l\[IAcute]nea ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_\[Gamma]\( f(x, 
            y)\) \[DifferentialD]s\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " es un campo escalar de dos variables y ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma] : \([a, 
            b]\) \[Rule] \[DoubleStruckCapitalR]\^2\)]],
  " es una curva en el plano que debes suponer conocidas. El comando debe \
tener la sintaxis \"aproxinteglinea[f_,\[Gamma]_,a_,b_,n_]\" y debe realizar \
las siguientes acciones:\n1. Dividir el intervalo [a,b] en n partes iguales \
por puntos ",
  Cell[BoxData[
      \(TraditionalForm\`t\_k = a + \(k(b - a)\)/n\)]],
  ". \n2. Calcular la suma ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(j = 1\)\%n f(\[Gamma](t\_j)) || \[Gamma](
            t\_\(j - 1\)) - \[Gamma](t\_j) || \)]],
  ".\nLos c\[AAcute]lculos deben realizarse num\[EAcute]ricamente. \nb) \
Calcula de forma exacta, usando el comando que has definido en el ejercicio \
1, el \[AAcute]rea de una cortina cuya base es la circunferencia",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\[Gamma](
          t) = \((1 + cos\ t, \ \ sen\ t)\)\)\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\(\(,\)\(\ \)\(0 \[LessEqual] t \[LessEqual] 
        2  \[Pi]\)\)\)]],
  " y cuya altura en cada punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " de la circunferencia viene dada por ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \(\(\@\(4 - x\^2 - y\^2\)\)\(.\)\)\)]],
  " Calcula, usando el comando que has definido en el apartado anterior, una \
aproximaci\[OAcute]n del valor obtenido con tres cifras decimales exactas. "
}], "ExerciseText"],

Cell[BoxData[
    \(aproxinteglinea[f_, \[Gamma]_, a_, b_, n_] := 
      Module[{t}, \[IndentingNewLine]t[j_] := 
          N[a + j*\((b - a)\)/n]; \[IndentingNewLine]Re[
          Sum[Apply[f, \[Gamma][t[j]]]*
              Norm[\[Gamma][t[j - 1]] - \[Gamma][t[j]]], {j, 1, 
              n}]]]\)], "Input"],

Cell[TextData[{
  "Uso el comando Re[ ] para quedarme con la parte real del resultado pues ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " introduce, debido a los redondeos en los c\[AAcute]lculos de la norma \
eucl\[IAcute]dea, una parte imaginaria del orden de ",
  Cell[BoxData[
      \(TraditionalForm\`10\^\(-17\)\)]],
  ". Una forma de eliminar n\[UAcute]meros menores que ",
  Cell[BoxData[
      \(TraditionalForm\`10\^\(-16\)\)]],
  " en los resultados de los c\[AAcute]lculos es usar el comando Chop[ ]."
}], "Text"],

Cell[BoxData[{
    \(\(f[x_, y_] = \@\(4 - x\^2 - y\^2\);\)\), "\[IndentingNewLine]", 
    \(\(\[Gamma][t_] = {1 + Cos[t], \ \ Sin[t]};\)\), "\[IndentingNewLine]", 
    \(aproxinteglinea[f, \[Gamma], 0, 2  \[Pi], 
      142]\), "\[IndentingNewLine]", 
    \(integlinea[f, \[Gamma], 0, 2  \[Pi]]\), "\[IndentingNewLine]", 
    \(\(\(Abs[% - %%]\)\(<\)\(0.001\)\( (*\ 
        esto\ quiere\ decir\ que\ la\ aproximaci\[OAcute]n\ obtenida\ tiene\ \
tres\ cifras\ decimales\ exactas\ *) \)\)\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicios 4 y 5", "Exercise"],

Cell["\<\
a) Define un comando que te diga si un campo vectorial es o no localmente \
conservativo. La sintaxis de dicho comando debe ser de la forma \
\"localconservativoQ[Func]\" donde se supone que \"Func\" es el campo \
vectorial y su salida debe ser \"El campo es localmente conservativo\" o \"El \
campo no es localmente conservativo\". \
\>", "ExerciseText"],

Cell["\<\
b) Define un comando que calcule simb\[OAcute]licamente la funci\[OAcute]n \
potencial que se anula en el origen de un campo vectorial de dos o tres \
variables. \
\>", "ExerciseText"],

Cell[BoxData[
    \(localconservativoQ[F_] := 
      If[Head[F[x, y]] === List,  (*\ 
          comprueba\ si\ el\ campo\ es\ de\ dos\ variables\ \
*) \[IndentingNewLine]If[
          Simplify[
              D[\(F[x, y]\)[\([1]\)], y] - D[\(F[x, y]\)[\([2]\)], x] == 0] === 
            True, Print["\<El campo\n\>"\ , F, \ "\<(x,y)=\>", \ 
            F[x, y], \ "\<\nes localmente conservativo\>"], 
          Print["\<El campo\n\>"\ , F, \ "\<(x,y)=\>", \ 
            F[x, y], \ "\<\nno es localmente conservativo\>"]], 
        If[Simplify[{D[\(F[x, y, z]\)[\([2]\)], z] - 
                    D[\(F[x, y, z]\)[\([3]\)], y], 
                  D[\(F[x, y, z]\)[\([3]\)], x] - 
                    D[\(F[x, y, z]\)[\([1]\)], z], 
                  D[\(F[x, y, z]\)[\([1]\)], y] - 
                    D[\(F[x, y, z]\)[\([2]\)], x]} == {0, 0, 0}] === True, 
          Print["\<El campo\n\>", F, \ "\<(x,y,z)=\>", \ 
            F[x, y, z], \ "\<\nes localmente conservativo\>"], 
          Print["\<El campo\n\>"\ , F, \ "\<(x,y,z)=\>", \ 
            F[x, y, z], \ "\<\nno es localmente conservativo\>"]]]\)], "Input"],

Cell[BoxData[{
    \(G[x_, y_] = {\(-y\)\/\(x\^2 + y\^2\), 
        x\/\(x\^2 + y\^2\)}\), "\[IndentingNewLine]", 
    \(localconservativoQ[G]\)}], "Input"],

Cell[BoxData[{
    \(\(H[x_, y_, z_] = \(1\/\@\((x\^2 + y\^2 + z\^2)\)\^3\) {x, y, z};\) (*\ 
      los\ campos\ el\[EAcute]ctricos\ producidos\ por\ cargas\ puntuales\ \
son\ de\ esta\ forma\ *) \), "\[IndentingNewLine]", 
    \(localconservativoQ[H]\)}], "Input"],

Cell[BoxData[
    \(\(potencial[F_, a_:  0, b_:  0, c_:  0, opts___]\)[x__] := 
      Module[{var = {x}, u, v, w}, 
        If[\((Simplify[
                  D[\(F[u, v]\)[\([1]\)], v] - D[\(F[u, v]\)[\([2]\)], u] == 
                    0] === True)\) || 
            Simplify[{D[\(F[u, v, w]\)[\([2]\)], w] - 
                      D[\(F[u, v, w]\)[\([3]\)], v], 
                    D[\(F[u, v, w]\)[\([3]\)], u] - 
                      D[\(F[u, v, w]\)[\([1]\)], w], 
                    D[\(F[u, v, w]\)[\([1]\)], v] - 
                      D[\(F[u, v, w]\)[\([2]\)], u]} == {0, 0, 0}] === True, 
          If[Length[var] \[Equal] 2, 
            Integrate[\(F[t, var[\([2]\)]]\)[\([1]\)], {t, a, var[\([1]\)]}, 
                opts] + 
              Integrate[\(F[a, t]\)[\([2]\)], {t, b, var[\([2]\)]}, opts], 
            Integrate[\(F[t, var[\([2]\)], var[\([3]\)]]\)[\([1]\)], {t, a, 
                  var[\([1]\)]}, opts] + 
              Integrate[\(F[a, t, var[\([3]\)]]\)[\([2]\)], {t, b, 
                  var[\([2]\)]}, opts] + 
              Integrate[\(F[a, b, t]\)[\([3]\)], {t, c, var[\([3]\)]}, 
                opts]]]]\)], "Input"],

Cell[TextData[{
  "En el comando anterior el s\[IAcute]mbolo x__ ( con DOS _ ) indica que ese \
lugar ser\[AAcute] reemplazado ",
  StyleBox["por una o m\[AAcute]s variables",
    FontWeight->"Bold"],
  ". Utilizo Module[ ] para localizar las variables respecto a las que se \
deriva para poder evaluar directamente la funci\[OAcute]n potencial en puntos \
concretos sin que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " proteste. Introduzco var={x} que es una lista con todas las variables y \
permite controlar cada una de ellas. La expresi\[OAcute]n a_:0 quiere decir \
que a es una variable que por defecto es igual a 0. El comando calcula el \
potencial que se anula en (a,b,c) que por defecto es (0,0,0). La variable \
opts___ (con TRES _ ) es algo, que puede no ser nada (es decir, \
vac\[IAcute]o), que pasa \"opts\" al comando Integrate[ ]."
}], "Text"],

Cell[BoxData[{
    \(\(F[x_, y_] = {2  y\^2 - 12 \( x\^3\) y\^3, 
          4  x\ y\  - \ 9 \( x\^4\) y\^2};\)\), "\n", 
    \(\(potencial[F]\)[x, y]\), "\[IndentingNewLine]", 
    \(\(potencial[F]\)[1, 1]\), "\[IndentingNewLine]", 
    \(Clear[F]\)}], "Input"],

Cell[BoxData[{
    \(\(H[x_, y_, z_] = {y, \ x + z\ Cos[y\ z], \ 
          y\ Cos[y\ z]};\)\), "\[IndentingNewLine]", 
    \(\(potencial[H]\)[x, y, z]\), "\[IndentingNewLine]", 
    \(\(potencial[H]\)[1, 2, 3]\), "\[IndentingNewLine]", 
    \(Clear[H]\)}], "Input"],

Cell["\<\
Podemos preguntarnos qu\[EAcute] ocurrir\[AAcute] si tratamos de aplicar este \
comando para calcular el potencial de un campo localmente conservativo pero \
que NO es conservativo (y por tanto no tiene funci\[OAcute]n potencial \
definida en todo su dominio de definici\[OAcute]n). \
\>", "Text"],

Cell[BoxData[{
    \(\(G[x_, y_] = {\(-y\)\/\(x\^2 + y\^2\), 
          x\/\(x\^2 + y\^2\)};\)\), "\[IndentingNewLine]", 
    \(localconservativoQ[G]\), "\[IndentingNewLine]", 
    \(\(\[Gamma][t_] = {Cos[t], Sin[t]};\)\), "\[IndentingNewLine]", 
    \(integlineavector[G, \[Gamma], 0, 
      2  Pi]\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(Print["\<Como la integral es distinta de 0 el campo\n\>"\ , 
      G, \ "\<(x,y)=\>", \ 
      G[x, y], \ \*"\"\<\\nNO es conservativo en \
\!\(R\^2\)\\{(0,0)}.\>\""]\)}], "Input"],

Cell[TextData[{
  "Intentemos calcular una funci\[OAcute]n potencial con el comando antes \
definido. Sabemos que dicho campo es conservativo en cualquier dominio \
simplemente conexo ",
  Cell[BoxData[
      \(TraditionalForm\`D \[Subset] R\^2\\{\((0, 0)\)}\)]],
  " pero NO es conservativo en todo ",
  Cell[BoxData[
      \(TraditionalForm\`R\^2\\{\((0, 0)\)}\)]],
  "."
}], "Text"],

Cell[BoxData[{
    RowBox[{\(\(potencial[G]\)[x, y]\), \( (*\ 
        la\ respuesta\ de\ Mathematica\ indica\ que\ las\ integrales\ \
dependen\ de\ la\ regi\[OAcute]n\ del\ plano\ a\ la\ que\ pertenezcan\ las\ \
variables\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(\(potencial[G, 0, 1, 0, 
          Assumptions \[Rule] x > 0 && y \[Element] Reals]\)[x, y]\), 
      RowBox[{"(*", " ", 
        RowBox[{
        "potencial", " ", "del", " ", "campo", " ", \(G[x, y]\), " ", "en", 
          " ", "el", " ", "semiplano", " ", "de", " ", "la", 
          " ", \(derecha . \ Observa\), " ", "que", " ", "esta", " ", 
          "funci\[OAcute]n", " ", "NO", " ", "est\[AAcute]", " ", "definida", 
          " ", "en", " ", "todo", " ", "R", 
          FormBox[\(\^2\\{\((0, 0)\)}\),
            "TraditionalForm"]}], " ", 
        "*)"}]}], "\[IndentingNewLine]", \({D[%, x], D[%, y]} // 
      Simplify\)}], "Input"],

Cell[BoxData[{
    RowBox[{\(\[Gamma][t_] = {2 + Cos[t], 1 + Sin[t]};\), \( (*\ 
        esta\ curva\ est\[AAcute]\ contenida\ en\ el\ semiplano\ de\ la\ \
derecha\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(integlineavector[G, \[Gamma], 0, 2  Pi]\), 
      RowBox[{"(*", " ", 
        RowBox[{\(esta\ integral\ vale\ 0\), ",", 
          " ", \(como\ debe\ ser\ para\ cualquier\ curva\ cerrada\ contenida\ \
en\ el\ semiplano\ de\ la\ derecha . \ De\ hecho\), ",", " ", 
          RowBox[{"la", " ", "integral", " ", "es", " ", "0", " ", 
            StyleBox["para",
              FontSlant->"Italic"], 
            StyleBox[" ",
              FontSlant->"Italic"], 
            StyleBox["toda",
              FontSlant->"Italic"], 
            StyleBox[" ",
              FontSlant->"Italic"], 
            StyleBox["curva",
              FontSlant->"Italic"], 
            StyleBox[" ",
              FontSlant->"Italic"], 
            StyleBox["cerrada",
              FontSlant->"Italic"], 
            StyleBox[" ",
              FontSlant->"Italic"], 
            StyleBox["que",
              FontSlant->"Italic"], 
            StyleBox[" ",
              FontSlant->"Italic"], 
            StyleBox["no",
              FontSlant->"Italic"], 
            StyleBox[" ",
              FontSlant->"Italic"], 
            StyleBox["rodee",
              FontSlant->"Italic"], 
            StyleBox[" ",
              FontSlant->"Italic"], 
            StyleBox["al",
              FontSlant->"Italic"], 
            StyleBox[" ",
              FontSlant->"Italic"], 
            StyleBox["origen",
              FontSlant->"Italic"]}]}], " ", "*)"}]}]}], "Input"],

Cell["\<\
Sabemos que el campo el\[EAcute]ctrico producido por una carga puntual es \
conservativo. Vamos a comprobarlo.\
\>", "Text"],

Cell[BoxData[{
    \(\(H[x_, y_, z_] = \(1\/\@\((x\^2 + y\^2 + z\^2)\)\^3\) {x, y, z};\) (*\ 
      los\ campos\ el\[EAcute]ctricos\ producidos\ por\ cargas\ puntuales\ \
son\ de\ esta\ forma\ *) \), "\[IndentingNewLine]", 
    \(\(potencial[H, 1, 1, 1, Assumptions \[Rule] x > 1 && y > 1 && z > 1]\)[
      x, y, z];  (*\ 
      tarda\ unos\ 20\ segundos\ *) \[IndentingNewLine]FullSimplify[%, 
      x \[Element] Reals && y \[Element] Reals && 
        z \[Element] Reals]\)}], "Input"],

Cell[TextData[{
  "Le hemos ayudado a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " a calcular la funci\[OAcute]n potencial que se anula en (1,1,1) porque \
para que las integrales puedan ser calculadas debemos especificar la regi\
\[OAcute]n a la que pertenece (x,y,z). ",
  StyleBox["Pero, a diferencia del ejemplo anterior, es claro que la funci\
\[OAcute]n obtenida est\[AAcute] definida y tiene derivadas parciales \
continuas en todo ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`R\^3\\{\((0, 0, 0)\)}\)],
    FontWeight->"Bold"],
  StyleBox[" y es por tanto una funci\[OAcute]n potencial de H(x,y,z) en todo \
",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`R\^3\\{\((0, 0, 0)\)}\)],
    FontWeight->"Bold"],
  StyleBox[", lo que nos dice que dicho campo es conservativo.",
    FontWeight->"Bold"]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "Usa ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para justificar la validez del teorema de Green para el caso de un rect\
\[AAcute]ngulo."
}], "ExerciseText"],

Cell[BoxData[{
    RowBox[{
      StyleBox[\(F[x_, y_] = {P[x, y], Q[x, y]};\)], 
      StyleBox[" "], 
      StyleBox["\[IndentingNewLine]",
        FontColor->GrayLevel[0]], 
      StyleBox[\( (*\ 
          consideramos\ el\ rect\[AAcute]ngulo\ [a, b]\[Times]\([c, 
              d]\)\ *) \),
        FontColor->GrayLevel[0]], 
      StyleBox["\[IndentingNewLine]",
        FontColor->GrayLevel[0]], 
      StyleBox[\( (*\ 
          la\ integral\ a\ lo\ largo\ de\ la\ poligonal\ [\((a, c)\), \((b, 
                c)\), \((b, d)\), \((a, d)\), \((a, 
                c)\)]\ es\ claramente\ lo\ que\ sigue\ a\ \
continuaci\[OAcute]n\ *) \),
        FontColor->GrayLevel[0]]}], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox["  ",
        FontColor->GrayLevel[0]], 
      RowBox[{
        StyleBox["expr1",
          FontColor->GrayLevel[0]], 
        StyleBox["=",
          FontColor->GrayLevel[0]], 
        RowBox[{
          RowBox[{
            StyleBox[\(\[Integral]\_a\%b\)], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["F"], 
                  StyleBox["["], 
                  RowBox[{
                    StyleBox["x"], 
                    StyleBox[","], "c"}], 
                  StyleBox["]"]}], 
                StyleBox["["], 
                StyleBox[\([1]\)], 
                StyleBox["]"]}], 
              StyleBox[\(\[DifferentialD]x\)]}]}], 
          StyleBox["+"], 
          
          StyleBox[\(\[Integral]\_c\%d\( F[b, 
                    y]\)[\([2]\)] \[DifferentialD]y\)], 
          StyleBox["-"], 
          RowBox[{
            StyleBox[\(\[Integral]\_a\%b\)], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["F"], 
                  StyleBox["["], 
                  RowBox[{
                    StyleBox["x"], 
                    StyleBox[","], "d"}], 
                  StyleBox["]"]}], 
                StyleBox["["], 
                StyleBox[\([1]\)], 
                StyleBox["]"]}], 
              StyleBox[\(\[DifferentialD]x\)]}]}], 
          StyleBox["-"], 
          RowBox[{
            StyleBox[\(\[Integral]\_c\%d\)], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["F"], 
                  StyleBox["["], 
                  RowBox[{"a", 
                    StyleBox[","], 
                    StyleBox["y"]}], 
                  StyleBox["]"]}], 
                StyleBox["["], 
                StyleBox[\([2]\)], 
                StyleBox["]"]}], 
              StyleBox[\(\[DifferentialD]y\)]}]}]}]}], 
      StyleBox["\[IndentingNewLine]",
        FontColor->GrayLevel[0]]}], "\n", 
    RowBox[{
      RowBox[{
        StyleBox["expr2",
          FontColor->GrayLevel[0]], 
        StyleBox["=",
          FontColor->GrayLevel[0]], 
        StyleBox[\(\[Integral]\_c\%d\((\ \[Integral]\_a\%b 
                        D[\(F[x, y]\)[\([2]\)], 
                        x] \[DifferentialD]x)\) \[DifferentialD]y - \ \
\[Integral]\_a\%b\((\[Integral]\_c\%d D[\(F[x, y]\)[\([1]\)], 
                        y] \[DifferentialD]y)\) \[DifferentialD]x\)]}], 
      StyleBox["\[IndentingNewLine]"], 
      RowBox[{
        StyleBox["(*"], 
        StyleBox[" "], 
        RowBox[{
          StyleBox[
            RowBox[{"E", 
              StyleBox["s"]}]], 
          StyleBox[" "], 
          StyleBox["evidente"], 
          StyleBox[" "], 
          StyleBox["que"], 
          StyleBox[" "], 
          StyleBox["los"], 
          StyleBox[" "], 
          StyleBox["resultados"], 
          StyleBox[" "], 
          StyleBox["obtenidos"], 
          StyleBox[" "], 
          StyleBox["son"], 
          StyleBox[" "], 
          StyleBox[\(iguales . \ Si\)], 
          StyleBox[" "], 
          StyleBox["queremos"], 
          StyleBox[" "], 
          StyleBox["comprobarlo"], 
          StyleBox[" "], 
          StyleBox["de"], 
          StyleBox[" "], 
          StyleBox["forma"], 
          StyleBox[" "], 
          StyleBox["m\[AAcute]s"], 
          StyleBox[" "], 
          StyleBox["completa"], 
          StyleBox[" "], 
          StyleBox["con"], 
          StyleBox[" "], 
          StyleBox["Mathematica"], 
          StyleBox[" "], 
          StyleBox["debemos"], 
          StyleBox[" "], 
          StyleBox["dar"], 
          StyleBox[" "], 
          StyleBox["reglas"], 
          StyleBox[" "], 
          StyleBox["adecuadas"]}], 
        StyleBox[" "], 
        StyleBox["*)"]}]}], "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{
        StyleBox["regla"], 
        StyleBox["="], 
        RowBox[{
          RowBox[{
            StyleBox["Integrate"], 
            StyleBox["["], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["-"], 
                  RowBox[{
                    StyleBox["f_"], 
                    StyleBox["["], 
                    StyleBox[
                      RowBox[{
                        StyleBox["x_"], "_"}]], 
                    StyleBox["]"]}]}], 
                StyleBox["+"], 
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["g"], "_"}]], 
                  StyleBox["["], 
                  StyleBox["w__"], 
                  StyleBox["]"]}]}], 
              StyleBox[","], 
              StyleBox[\({y_, u_, v_}\)]}], 
            StyleBox["]"]}], 
          StyleBox["\[RuleDelayed]"], 
          RowBox[{
            StyleBox[\(-Integrate[f[x], {y, u, v}]\)], 
            StyleBox["+"], 
            RowBox[{
              StyleBox["Integrate"], 
              StyleBox["["], 
              RowBox[{
                RowBox[{
                  StyleBox["g"], 
                  StyleBox["["], "w", 
                  StyleBox["]"]}], 
                StyleBox[","], 
                StyleBox[\({y, u, v}\)]}], 
              StyleBox["]"]}]}]}]}], 
      StyleBox[";"]}], "\[IndentingNewLine]", 
    StyleBox[\(expr2 /. regla\)], "\[IndentingNewLine]", 
    StyleBox[\(expr1 == expr2 /. regla\)]}], "Input"],

Cell["Los dem\[AAcute]s ejercicios no ofrecen ninguna dificultad.", "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 66, 0, 99, "Title"],

Cell[CellGroupData[{
Cell[1845, 55, 39, 0, 93, "Section"],
Cell[1887, 57, 319, 5, 67, "Text"],

Cell[CellGroupData[{
Cell[2231, 66, 31, 0, 68, "Exercise"],
Cell[2265, 68, 484, 7, 119, "ExerciseText"],
Cell[2752, 77, 194, 4, 106, "Input"],
Cell[2949, 83, 690, 12, 145, "Text"],
Cell[3642, 97, 114, 2, 98, "Input"],
Cell[3759, 101, 193, 4, 124, "Input"],
Cell[3955, 107, 446, 8, 202, "Input"],
Cell[4404, 117, 55, 0, 41, "Text"],
Cell[4462, 119, 77, 1, 72, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4576, 125, 31, 0, 68, "Exercise"],
Cell[4610, 127, 244, 4, 67, "ExerciseText"],
Cell[4857, 133, 154, 3, 94, "Input"],
Cell[5014, 138, 145, 3, 41, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5196, 146, 31, 0, 68, "Exercise"],
Cell[5230, 148, 1762, 39, 313, "ExerciseText"],
Cell[6995, 189, 308, 6, 146, "Input"],
Cell[7306, 197, 537, 12, 93, "Text"],
Cell[7846, 211, 501, 8, 264, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8384, 224, 36, 0, 68, "Exercise"],
Cell[8423, 226, 365, 6, 93, "ExerciseText"],
Cell[8791, 234, 194, 4, 67, "ExerciseText"],
Cell[8988, 240, 1122, 20, 458, "Input"],
Cell[10113, 262, 156, 3, 145, "Input"],
Cell[10272, 267, 265, 4, 218, "Input"],
Cell[10540, 273, 1159, 21, 354, "Input"],
Cell[11702, 296, 875, 16, 171, "Text"],
Cell[12580, 314, 261, 5, 173, "Input"],
Cell[12844, 321, 266, 5, 172, "Input"],
Cell[13113, 328, 307, 5, 67, "Text"],
Cell[13423, 335, 532, 10, 253, "Input"],
Cell[13958, 347, 385, 10, 67, "Text"],
Cell[14346, 359, 919, 17, 250, "Input"],
Cell[15268, 378, 1672, 43, 224, "Input"],
Cell[16943, 423, 134, 3, 41, "Text"],
Cell[17080, 428, 488, 8, 248, "Input"],
Cell[17571, 438, 873, 22, 119, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18481, 465, 31, 0, 68, "Exercise"],
Cell[18515, 467, 191, 6, 41, "ExerciseText"],
Cell[18709, 475, 6117, 186, 536, "Input"],
Cell[24829, 663, 75, 0, 41, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

